$networkAdapters = Get-NetAdapter | Where-Object { $_.Status -eq 'Up' }

$publicAdapter = $networkAdapters | Where-Object {
    $adapter = $_
    $ipConfig = Get-NetIPConfiguration -InterfaceIndex $adapter.IfIndex
    $ipConfig.IPv4DefaultGateway -ne $null
} | Select-Object -First 1

if ($publicAdapter) {
    Write-Host "yes $($publicAdapter.IfIndex)" 
    $ifIndex = $publicAdapter.IfIndex
    Get-NetIPAddress -InterfaceIndex $ifIndex -AddressFamily IPv4 | Remove-NetIPAddress -Confirm:$false
    Get-NetRoute -InterfaceIndex $ifIndex | Where-Object { $_.DestinationPrefix -eq "0.0.0.0/0" } | Remove-NetRoute -Confirm:$false
for ($i = 42 ; $i -le 46; $i++) {
        $ip = "206.233.232.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 29
    }
New-NetRoute -InterfaceIndex $ifIndex -DestinationPrefix 0.0.0.0/0 -NextHop 206.233.232.41
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "206.233.224.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "206.233.225.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "206.233.226.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "206.233.227.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "206.233.228.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "206.233.229.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "206.233.230.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "206.233.231.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
} else {
    Write-Host "no"
}
