$networkAdapters = Get-NetAdapter | Where-Object { $_.Status -eq 'Up' }

$publicAdapter = $networkAdapters | Where-Object {
    $adapter = $_
    $ipConfig = Get-NetIPConfiguration -InterfaceIndex $adapter.IfIndex
    $ipConfig.IPv4DefaultGateway -ne $null
} | Select-Object -First 1

if ($publicAdapter) {
    Write-Host "yes $($publicAdapter.IfIndex)" 
    $ifIndex = $publicAdapter.IfIndex
    Get-NetIPAddress -InterfaceIndex $ifIndex -AddressFamily IPv4 | Remove-NetIPAddress -Confirm:$false
    Get-NetRoute -InterfaceIndex $ifIndex | Where-Object { $_.DestinationPrefix -eq "0.0.0.0/0" } | Remove-NetRoute -Confirm:$false
for ($i = 90 ; $i -le 94; $i++) {
        $ip = "156.240.14.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 29
    }
New-NetRoute -InterfaceIndex $ifIndex -DestinationPrefix 0.0.0.0/0 -NextHop 156.240.14.89
for ($i = 162 ; $i -le 190; $i++) {
        $ip = "154.55.227.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 162 ; $i -le 190; $i++) {
        $ip = "154.55.229.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 162 ; $i -le 190; $i++) {
        $ip = "154.55.231.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 162 ; $i -le 190; $i++) {
        $ip = "154.55.233.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 162 ; $i -le 190; $i++) {
        $ip = "154.55.235.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 162 ; $i -le 190; $i++) {
        $ip = "154.55.237.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 162 ; $i -le 190; $i++) {
        $ip = "154.55.239.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 162 ; $i -le 190; $i++) {
        $ip = "154.55.241.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
} else {
    Write-Host "no"
}
