$networkAdapters = Get-NetAdapter | Where-Object { $_.Status -eq 'Up' }

$publicAdapter = $networkAdapters | Where-Object {
    $adapter = $_
    $ipConfig = Get-NetIPConfiguration -InterfaceIndex $adapter.IfIndex
    $ipConfig.IPv4DefaultGateway -ne $null
} | Select-Object -First 1

if ($publicAdapter) {
    Write-Host "yes $($publicAdapter.IfIndex)" 
    $ifIndex = $publicAdapter.IfIndex
    Get-NetIPAddress -InterfaceIndex $ifIndex -AddressFamily IPv4 | Remove-NetIPAddress -Confirm:$false
    Get-NetRoute -InterfaceIndex $ifIndex | Where-Object { $_.DestinationPrefix -eq "0.0.0.0/0" } | Remove-NetRoute -Confirm:$false
for ($i = 130 ; $i -le 134; $i++) {
        $ip = "156.240.14.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 29
    }
New-NetRoute -InterfaceIndex $ifIndex -DestinationPrefix 0.0.0.0/0 -NextHop 156.240.14.129
for ($i = 98 ; $i -le 126; $i++) {
        $ip = "45.200.26.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 98 ; $i -le 126; $i++) {
        $ip = "45.200.28.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 98 ; $i -le 126; $i++) {
        $ip = "45.200.30.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 98 ; $i -le 126; $i++) {
        $ip = "45.200.31.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 2 ; $i -le 30; $i++) {
        $ip = "154.55.227.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 2 ; $i -le 30; $i++) {
        $ip = "154.55.229.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 2 ; $i -le 30; $i++) {
        $ip = "154.55.231.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 2 ; $i -le 30; $i++) {
        $ip = "154.55.233.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
} else {
    Write-Host "no"
}
