$networkAdapters = Get-NetAdapter | Where-Object { $_.Status -eq 'Up' }

$publicAdapter = $networkAdapters | Where-Object {
    $adapter = $_
    $ipConfig = Get-NetIPConfiguration -InterfaceIndex $adapter.IfIndex
    $ipConfig.IPv4DefaultGateway -ne $null
} | Select-Object -First 1

if ($publicAdapter) {
    Write-Host "yes $($publicAdapter.IfIndex)" 
    $ifIndex = $publicAdapter.IfIndex
    Get-NetIPAddress -InterfaceIndex $ifIndex -AddressFamily IPv4 | Remove-NetIPAddress -Confirm:$false
    Get-NetRoute -InterfaceIndex $ifIndex | Where-Object { $_.DestinationPrefix -eq "0.0.0.0/0" } | Remove-NetRoute -Confirm:$false
for ($i = 74 ; $i -le 78; $i++) {
        $ip = "154.55.132.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 29
    }
New-NetRoute -InterfaceIndex $ifIndex -DestinationPrefix 0.0.0.0/0 -NextHop 154.55.132.73
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "154.55.194.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "154.55.196.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "154.55.198.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "154.55.200.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "154.55.202.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "154.55.204.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "154.55.206.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 34 ; $i -le 62; $i++) {
        $ip = "154.55.208.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
} else {
    Write-Host "no"
}
