$networkAdapters = Get-NetAdapter | Where-Object { $_.Status -eq 'Up' }

$publicAdapter = $networkAdapters | Where-Object {
    $adapter = $_
    $ipConfig = Get-NetIPConfiguration -InterfaceIndex $adapter.IfIndex
    $ipConfig.IPv4DefaultGateway -ne $null
} | Select-Object -First 1

if ($publicAdapter) {
    Write-Host "yes $($publicAdapter.IfIndex)" 
    $ifIndex = $publicAdapter.IfIndex
    Get-NetIPAddress -InterfaceIndex $ifIndex -AddressFamily IPv4 | Remove-NetIPAddress -Confirm:$false
    Get-NetRoute -InterfaceIndex $ifIndex | Where-Object { $_.DestinationPrefix -eq "0.0.0.0/0" } | Remove-NetRoute -Confirm:$false
for ($i = 250 ; $i -le 254; $i++) {
        $ip = "156.240.14.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 29
    }
New-NetRoute -InterfaceIndex $ifIndex -DestinationPrefix 0.0.0.0/0 -NextHop 156.240.14.249
for ($i = 2 ; $i -le 254; $i++) {
        $ip = "156.240.51.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 24
    }
} else {
    Write-Host "no"
}
