$networkAdapters = Get-NetAdapter | Where-Object { $_.Status -eq 'Up' }

$publicAdapter = $networkAdapters | Where-Object {
    $adapter = $_
    $ipConfig = Get-NetIPConfiguration -InterfaceIndex $adapter.IfIndex
    $ipConfig.IPv4DefaultGateway -ne $null
} | Select-Object -First 1

if ($publicAdapter) {
    Write-Host "yes $($publicAdapter.IfIndex)" 
    $ifIndex = $publicAdapter.IfIndex
    Get-NetIPAddress -InterfaceIndex $ifIndex -AddressFamily IPv4 | Remove-NetIPAddress -Confirm:$false
    Get-NetRoute -InterfaceIndex $ifIndex | Where-Object { $_.DestinationPrefix -eq "0.0.0.0/0" } | Remove-NetRoute -Confirm:$false
for ($i = 114 ; $i -le 118; $i++) {
        $ip = "206.233.190.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 29
    }
New-NetRoute -InterfaceIndex $ifIndex -DestinationPrefix 0.0.0.0/0 -NextHop 206.233.190.113
for ($i = 66 ; $i -le 94; $i++) {
        $ip = "154.216.164.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 66 ; $i -le 94; $i++) {
        $ip = "154.216.165.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 66 ; $i -le 94; $i++) {
        $ip = "154.216.166.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 66 ; $i -le 94; $i++) {
        $ip = "154.216.167.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 66 ; $i -le 94; $i++) {
        $ip = "154.216.168.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 66 ; $i -le 94; $i++) {
        $ip = "154.216.169.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 66 ; $i -le 94; $i++) {
        $ip = "154.216.170.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
for ($i = 66 ; $i -le 94; $i++) {
        $ip = "154.216.171.$i"
            New-NetIPAddress -InterfaceIndex $ifIndex -IPAddress $ip -PrefixLength 27
    }
} else {
    Write-Host "no"
}
